/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.cbs.tcp.service;

import com.cspl.api.message.Header;
import com.cspl.api.message.IMessage;
import com.cspl.library.EndianLibrary;
import org.springframework.stereotype.Service;

@Service
public class MessageFormationServiceCBS {
    public byte[] getMessageByteArray(Header messageHeader, IMessage messageBody) throws Exception {
        byte[] headerBytes = new byte[]{};
        byte[] dataBytes = new byte[]{};
        int messageLength = 0;
        boolean isReverseEndian = false;
        if (messageBody != null) {
            dataBytes = messageBody.getByteArray();
        }
        messageLength = messageHeader.getHeaderMessageSize() + dataBytes.length;
        messageHeader.setmessageLength(isReverseEndian ? EndianLibrary.convertLittleEndianToBigEndian((int)messageLength) : messageLength);
        headerBytes = messageHeader.getByteArray();
        byte[] returnValue = new byte[messageLength];
        System.arraycopy(headerBytes, 0, returnValue, 0, headerBytes.length);
        System.arraycopy(dataBytes, 0, returnValue, headerBytes.length, dataBytes.length);
        return returnValue;
    }

    public Header getMessageHeader(byte[] headerBytes) {
        Header returnValue = new Header();
        returnValue.setByteArray(headerBytes);
        return returnValue;
    }

    public IMessage getMessageBody(Header headerMessage, byte[] dataBytes) {
        IMessage messageBody = headerMessage.getMessageObjectByType(headerMessage.getmessageType());
        if (messageBody != null) {
            messageBody.setByteArray(dataBytes);
        }
        return messageBody;
    }
}

