/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.config;

import com.cspl.fxretailhub.service.ConfigurationValuesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.inject.Inject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class ConditionalRejectionInterceptor
implements HandlerInterceptor {
    @Inject
    private ConfigurationValuesService configurationValuesService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestUri = request.getRequestURI();
        if (!this.shouldReject(requestUri)) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return false;
        }
        return super.preHandle(request, response, handler);
    }

    private boolean shouldReject(String requestUri) {
        return this.configurationValuesService.getIsEnableRESTAPI();
    }
}

