/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.pi.rest.service;

import com.cspl.fxretailhub.pi.services.PIMessageSendingService;
import com.cspl.fxretailhub.service.ConfigurationValuesService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.fxretailhub.service.MessageProcessingService;
import com.cspl.fxretailhub.shared.CBSClient;
import javax.inject.Inject;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PIRESTClientService
implements ICommunicationInterface {
    @Value(value="${ccilfx.hub.pi.rest.protocol}")
    private String interfaceProtocol;
    @Value(value="${ccilfx.hub.pi.rest.identifier}")
    private String interfaceIdentifier;
    @Inject
    private ConfigurationValuesService configurationValuesService;
    @Inject
    private PIMessageSendingService messageSendingService;
    @Inject
    @Qualifier(value="RESTTemplate")
    private RestTemplate restTemplate;
    private Boolean isConnectSuccess = true;
    private MessageProcessingService messageProcessingService;
    private static final Logger log = LoggerFactory.getLogger(PIRESTClientService.class);

    public void initialise(MessageProcessingService messageProcessingService) {
        this.messageProcessingService = messageProcessingService;
    }

    public Boolean isConnected() {
        return this.isConnectSuccess;
    }

    public Boolean sendPIMessage(String message) {
        String bIBaseURL = this.getBaseURI() + "/send";
        String responseString = "";
        boolean sendSuccess = false;
        try {
            HttpHeaders headers = this.getHeaders();
            HttpEntity requestBody = new HttpEntity((Object)message, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(bIBaseURL, (Object)requestBody, String.class, new Object[0]);
            this.validateResponse(response);
            responseString = (String)response.getBody();
            this.messageProcessingService.processHTTPPIResponseMessage(responseString);
            sendSuccess = true;
        }
        catch (Exception exception) {
            log.error("Error in sendPIMessage : " + ExceptionUtils.getFullStackTrace((Throwable)exception));
        }
        return sendSuccess;
    }

    public Boolean sendMessage(String message, CBSClient client) {
        return null;
    }

    private String getBaseURI() {
        return this.interfaceProtocol + "://" + this.configurationValuesService.getPiHost() + ":" + this.configurationValuesService.getPiPort() + "/" + this.interfaceIdentifier;
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        return headers;
    }

    private <R> void validateResponse(ResponseEntity<R> response) {
        try {
            if (response.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusCode());
            }
        }
        catch (Exception exception) {
            log.error("Error in validateResponse : " + exception.getMessage());
            throw new IllegalArgumentException(exception.getMessage());
        }
    }
}

