/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.cbs.service.thread;

import com.cspl.fxretailhub.cbs.service.CBSMessageSendingService;
import com.cspl.fxretailhub.cbs.service.CBSMessagingService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.fxretailhub.shared.CBSClient;
import com.cspl.pi.services.dto.PIQueueDTO;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBSMessageSendingThread
extends Thread {
    private Logger log = LoggerFactory.getLogger(CBSMessageSendingThread.class);
    private CBSMessageSendingService messageSendingService;
    private CBSMessagingService messagingService;
    private ICommunicationInterface communicationInterface;
    private CBSClient bisClient;

    public CBSMessageSendingThread(CBSMessagingService messagingService, CBSMessageSendingService messageSendingService, ICommunicationInterface communicationInterface, CBSClient bisClient) {
        this.messagingService = messagingService;
        this.messageSendingService = messageSendingService;
        this.communicationInterface = communicationInterface;
        this.bisClient = bisClient;
    }

    @Override
    public void run() {
        this.log.info("BIS client socket write thread started for :" + this.bisClient.getApiKey());
        Boolean sendSuccess = false;
        while (true) {
            try {
                while (true) {
                    PIQueueDTO message;
                    if ((message = this.messagingService.checkAndGetMessageFromCBSQueue(this.bisClient.getApiKey())) != null) {
                        sendSuccess = false;
                        this.log.info("BIS Message fetched from queue");
                        while (!sendSuccess.booleanValue()) {
                            if (this.communicationInterface.isConnected().booleanValue()) {
                                sendSuccess = this.messageSendingService.checkAckAndSendMessage(this.messagingService, message, this.bisClient);
                                if (!sendSuccess.booleanValue()) {
                                    Thread.sleep(500L);
                                    this.log.info("Resending BIS message");
                                    continue;
                                }
                                this.messagingService.updateSentStatus(message, this.bisClient.getApiKey());
                                continue;
                            }
                            Thread.sleep(500L);
                        }
                        Thread.sleep(20L);
                        continue;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                this.log.error("Exception while execution - " + ExceptionUtils.getFullStackTrace((Throwable)ex));
                continue;
            }
            break;
        }
    }
}

