/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.config;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Timeout;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RESTConfiguration {
    @Value(value="${ccilfx.hub.rest.connectiontimeout}")
    private String connectionTimeout;
    @Value(value="${ccilfx.hub.rest.maxconnectionpool}")
    private String maxConnectionPool;
    @Value(value="${ccilfx.hub.rest.maxparallelconnection}")
    private String maxParallelConnection;

    @Bean
    @Qualifier(value="RESTTemplate")
    public RestTemplate createRestTemplate() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        HttpComponentsClientHttpRequestFactory factory = null;
        TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(acceptingTrustStrategy).build();
        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        connectionManager.setMaxTotal(Integer.parseInt(this.maxConnectionPool));
        connectionManager.setDefaultMaxPerRoute(Integer.parseInt(this.maxParallelConnection));
        RequestConfig config = RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)Integer.parseInt(this.connectionTimeout))).build();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(config).build();
        factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        return restTemplate;
    }
}

