/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.pi.services;

import com.cspl.fxretailhub.pi.rest.service.PIRESTClientService;
import com.cspl.fxretailhub.pi.services.PIMessagingService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.pi.services.dto.PIQueueDTO;
import java.io.IOException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PIMessageSendingService {
    private Logger log = LoggerFactory.getLogger(PIMessageSendingService.class);
    @Value(value="${ccilfx.hub.ackCheckIntevalInMilliSec}")
    private String ackCheckIntevalInMilliSec;
    @Value(value="${ccilfx.hub.ackCheckRetryCount}")
    private String ackCheckRetryCount;
    private ICommunicationInterface communicationInterface;
    @Inject
    private PIRESTClientService restClientService;

    public void initialise(ICommunicationInterface communicationInterface) {
        this.communicationInterface = communicationInterface;
    }

    public boolean checkAckAndSendMessage(PIMessagingService cbsMessagingService, PIQueueDTO message) throws IOException {
        try {
            this.log.info("Ack received status from PI is - " + cbsMessagingService.getIsPIAckReceived());
            Integer ackCheckAttemptCount = 0;
            cbsMessagingService.setIsPIAckReceived(Boolean.valueOf(false));
            boolean sendSuccess = this.sendMessage(message.getMessage());
            if (!sendSuccess) {
                cbsMessagingService.setIsPIAckReceived(Boolean.valueOf(true));
            } else {
                this.log.info("Message sent waiting for ack from PI.");
            }
            while (!cbsMessagingService.getIsPIAckReceived().booleanValue()) {
                if ((ackCheckAttemptCount = Integer.valueOf(ackCheckAttemptCount + 1)) > Integer.parseInt(this.ackCheckRetryCount)) {
                    sendSuccess = false;
                    this.log.info("Ack not received from PI.");
                    break;
                }
                Thread.sleep(Integer.parseInt(this.ackCheckIntevalInMilliSec));
            }
            if (sendSuccess) {
                this.log.info("Ack received from PI.");
            }
            return sendSuccess;
        }
        catch (Exception e) {
            this.log.error("send message failure from PI - Exception : " + e);
            return false;
        }
    }

    public synchronized boolean sendMessage(String message) {
        try {
            this.log.info("Send message begin to PI");
            boolean sendSuccess = false;
            sendSuccess = this.communicationInterface.sendPIMessage(message);
            this.log.info("Send message to PI complete");
            return sendSuccess;
        }
        catch (Exception e) {
            this.log.error("send message to PI - Exception : " + e);
            return false;
        }
    }
}

