/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.pi.services;

import com.cspl.fxretailhub.library.FileManipulationLibrary;
import com.cspl.fxretailhub.pi.services.PIMessageSendingService;
import com.cspl.fxretailhub.pi.services.thread.PIMessageSendingThread;
import com.cspl.fxretailhub.service.ConfigurationValuesService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.pi.services.dto.PIQueueDTO;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.Queue;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PIMessagingService {
    @Inject
    private PIMessageSendingService messageSendingService;
    @Inject
    private ConfigurationValuesService configurationValuesService;
    private Boolean isPIAckReceived = false;
    private Queue<PIQueueDTO> piMessageQueue = new LinkedList();
    private Logger log = LoggerFactory.getLogger(PIMessagingService.class);

    public void initialise(ICommunicationInterface communicationInterface) {
        this.messageSendingService.initialise(communicationInterface);
        PIMessageSendingThread messageSendingThread = new PIMessageSendingThread(this, this.messageSendingService, communicationInterface);
        messageSendingThread.start();
    }

    public void fetchAndProcessUnSentMessages() {
        try {
            File[] files;
            for (File file : files = com.cspl.library.FileManipulationLibrary.getFilesOfGivenExtensionInGivenPath((String)this.configurationValuesService.getHUBPIQueuedMessageOutboxLocation(), (String)"txt")) {
                String fileName = FilenameUtils.removeExtension((String)file.getName());
                byte[] fileContent = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
                this.putMessageIntoPIQueue(new PIQueueDTO(fileName, new String(fileContent)));
            }
        }
        catch (Exception ex) {
            this.log.error("Error while fetching unprocessed messages - " + ex.getMessage());
        }
    }

    public Boolean getIsPIAckReceived() {
        return this.isPIAckReceived;
    }

    public void setIsPIAckReceived(Boolean isCBSAckReceived) {
        this.isPIAckReceived = isCBSAckReceived;
    }

    public void sendMessage(String messageReferenceNo, String originatingTimeStamp, String messageString) throws IOException {
        String fileName = messageReferenceNo + "_" + originatingTimeStamp;
        PIQueueDTO message = new PIQueueDTO(fileName, messageString);
        this.persistPIMessage(message);
        this.putMessageIntoPIQueue(message);
    }

    public void persistPIMessage(PIQueueDTO message) throws IOException {
        String fileLocation = this.configurationValuesService.getHUBPIQueuedMessageOutboxLocation() + "/" + message.getFileName() + ".txt";
        FileManipulationLibrary.setFilePermissions((Path)Paths.get(fileLocation, new String[0]));
        Files.write(Paths.get(fileLocation, new String[0]), message.getMessage().getBytes(), new OpenOption[0]);
    }

    public void updateSentStatus(PIQueueDTO message) {
        String sourcePath = this.configurationValuesService.getHUBPIQueuedMessageOutboxLocation() + "/" + message.getFileName() + ".txt";
        try {
            String destinationPath = this.configurationValuesService.getHUBPIQueuedMessageAckedLocation() + "/" + message.getFileName() + ".txt";
            com.cspl.library.FileManipulationLibrary.moveFile((String)sourcePath, (String)destinationPath);
        }
        catch (IOException e) {
            try {
                com.cspl.library.FileManipulationLibrary.checkAndDeleteFile((String)sourcePath);
            }
            catch (IOException e1) {
                this.log.error("Error in updateSentStatus : " + e1.getMessage());
            }
            this.log.error("Error while update sent status - " + message.getFileName() + " - Exception : " + e);
        }
    }

    public void putMessageIntoPIQueue(PIQueueDTO message) {
        this.piMessageQueue.add(message);
    }

    public PIQueueDTO checkAndGetMessageFromPIQueue() {
        if (this.piMessageQueue.isEmpty()) {
            return null;
        }
        return (PIQueueDTO)this.piMessageQueue.remove();
    }

    public boolean sendMessage(String message) {
        boolean returnValue = true;
        if (message != null && !message.isEmpty()) {
            returnValue = this.messageSendingService.sendMessage(message);
        }
        return returnValue;
    }
}

