/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.service;

import com.cspl.api.enumeration.PIHeaderRejectionCode;
import com.cspl.api.enumeration.RejectionLevelLookup;
import com.cspl.api.shared.SharedValues;
import com.cspl.fxretailhub.cbs.service.CBSMessagingService;
import com.cspl.fxretailhub.enumeration.MessageType;
import com.cspl.fxretailhub.enumeration.PIProtocols;
import com.cspl.fxretailhub.pi.services.PIMessagingService;
import com.cspl.fxretailhub.service.ConfigurationValuesService;
import com.cspl.fxretailhub.shared.CBSClient;
import com.cspl.fxretailhub.shared.ClientArray;
import com.cspl.library.FileManipulationLibrary;
import com.cspl.pi.message.Message;
import com.cspl.pi.message.RepeatingBlock;
import com.cspl.pi.message.ResendAfterTimestampMessage;
import com.cspl.pi.message.enumeration.PIMessageTypes;
import com.cspl.pi.message.enumeration.SourceType;
import com.cspl.pi.message.shared.MessageStatus;
import com.cspl.pi.message.shared.MessageValues;
import com.cspl.pi.services.PIMessageGenerationService;
import com.cspl.pi.services.dto.PIMessageGeneratorDTO;
import com.cspl.pi.services.dto.PIQueueDTO;
import com.cspl.pi.shared.PISharedFunctions;
import com.cspl.pi.shared.PISharedValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MessageProcessingService {
    @Inject
    private CBSMessagingService cbsMessagingService;
    @Inject
    private PIMessagingService piMessagingService;
    private PIMessageGenerationService messageGenerationService;
    @Inject
    private ConfigurationValuesService configurationValuesService;
    @Inject
    private ObjectMapper jacksonObjectMapper;
    private Logger log = LoggerFactory.getLogger(MessageProcessingService.class);

    public void initialise() {
        this.messageGenerationService = new PIMessageGenerationService();
    }

    @Scheduled(cron="${ccilfx.hub.processedQueueMessageArchiveTime}")
    public void archiveProcessMessages() {
        try {
            if (!this.configurationValuesService.getHubProtocol().equals(PIProtocols.NONE.toString())) {
                for (Map.Entry entry : this.configurationValuesService.getCBSConnectivityDetails().entrySet()) {
                    String apiKey = ((CBSClient)entry.getValue()).getApiKey();
                    FileManipulationLibrary.moveAllFiles((String)this.configurationValuesService.getPiCBSQueuedMessageAckedLocation(apiKey), (String)this.configurationValuesService.getPiCBSQueuedMessageArchiveLocation(apiKey));
                }
                this.log.info("Message logs archived");
            }
        }
        catch (Exception ex) {
            this.log.error("Error while archiving message - " + ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
    }

    public String processHTTPCBSMessage(String message, HttpServletRequest request) {
        return this.processCBSMessage(message, request);
    }

    public String addActiveBISClient(String message, HttpServletRequest request) {
        return this.addClient(message, request);
    }

    private String addClient(String message, HttpServletRequest request) {
        String returnValue = "FAILURE";
        try {
            String API_ID = request.getHeader("APIKEY");
            if (!ClientArray.checkClientDetail((String)message)) {
                ClientArray.insertClientDetail((String)message, (String)API_ID);
                returnValue = "SUCCESS";
                if (API_ID.equals("TRADE_HDFC000521")) {
                    this.log.info("trade client connected " + message);
                } else {
                    this.log.info("other client connected " + message);
                }
            }
        }
        catch (Exception ex) {
            this.log.info("active client insert error " + message + " - " + ex.toString());
            returnValue = "FAILURE";
        }
        return returnValue;
    }

    private String processCBSMessage(String messageString, HttpServletRequest request) {
        String returnValue = "";
        String headerapiKey = "";
        String apiKey = "";
        try {
            this.log.info("Incoming Message - " + messageString);
            headerapiKey = request.getHeader("APIKEY");
            CBSClient cbsClient = this.getCBSConnectivityDetail(headerapiKey);
            if (cbsClient.getApiKey().equals(headerapiKey)) {
                apiKey = cbsClient.getApiKey();
            }
            PISharedValues.p_Destination = apiKey;
            PIMessageGeneratorDTO messageGeneratorDTO = this.messageGenerationService.parseAndGetMessage(apiKey, messageString, this.configurationValuesService.getHubToBisencryptionRequired());
            if (messageGeneratorDTO.getMessageStatus() == null || messageGeneratorDTO.getMessageStatus().size() == 0) {
                this.log.info("Message reference: " + messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo() + ",Api key: " + apiKey);
                String mrnWithApiKey = messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo() + "_" + apiKey;
                if (messageGeneratorDTO.getMessage().getHeader().getMessageType().equals(PIMessageTypes.AD03.toString())) {
                    this.log.info("Heart beat message received from " + PISharedValues.p_Destination);
                } else if (!this.checkRequestMessageIPAddressIsValid(messageGeneratorDTO.getMessage().getHeader().getMessageType(), request.getHeader("APIKEY"), request.getHeader("IP"), request.getHeader("PORT"))) {
                    returnValue = this.generateInvalidIPAddressMessage(messageGeneratorDTO, apiKey);
                } else if (!this.messageGenerationService.isMRNwithAPIKeyExists(mrnWithApiKey).booleanValue()) {
                    SharedValues.processedMessageReferenceNumbersAndAPIKey.put(messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo(), apiKey);
                    returnValue = this.processCBSMessage(messageGeneratorDTO.getMessage(), apiKey);
                    this.messageGenerationService.addMRNwithAPIKey(mrnWithApiKey);
                } else {
                    this.log.info("MRN already exists " + messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo());
                    this.genarateDuplicateMRNValue(messageGeneratorDTO, apiKey);
                    returnValue = this.generateAndGetAckMessage(apiKey, messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo(), this.configurationValuesService.getHubToBisencryptionRequired().booleanValue());
                }
            } else {
                this.generateAndSendProcessStatusMessage(messageGeneratorDTO, apiKey);
                String mrn = "01";
                if (messageGeneratorDTO.getMessageStatus() != null && messageGeneratorDTO.getMessageStatus().size() > 0) {
                    mrn = ((MessageStatus)messageGeneratorDTO.getMessageStatus().get(messageGeneratorDTO.getMessageStatus().size() - 1)).getmRNOfSourceMessage();
                }
                returnValue = this.generateAndGetAckMessage(apiKey, mrn, this.configurationValuesService.getHubToBisencryptionRequired().booleanValue());
            }
        }
        catch (Exception ex) {
            this.log.error("Error while processing BIS message - " + ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
        if (!returnValue.isEmpty()) {
            this.log.info("Outgoing Message - " + returnValue);
        }
        return returnValue;
    }

    private boolean checkRequestMessageIPAddressIsValid(String requestMessageType, String apikey, String ipAddress, String port) {
        boolean isValid = false;
        if (requestMessageType.equals(PIMessageTypes.AD02.toString())) {
            return true;
        }
        CBSClient cbsClient = this.getCBSConnectivityDetail(apikey);
        if (cbsClient != null) {
            isValid = this.validateIpAddressPortAndMessageType(cbsClient, requestMessageType, apikey, ipAddress, port);
        }
        return isValid;
    }

    private boolean validateIpAddressPortAndMessageType(CBSClient cbsClient, String requestMessageType, String apikey, String ipAddress, String port) {
        MessageType messageType = Arrays.stream(MessageType.values()).filter(type -> type.getValue().equals(requestMessageType)).findAny().get();
        if (cbsClient != null) {
            return cbsClient.getIpaddress().equals(ipAddress) && cbsClient.getPort().equals(port) && cbsClient.getAllowedMessageTypes().contains(messageType);
        }
        return false;
    }

    private CBSClient getCBSConnectivityDetail(String apikey) {
        return (CBSClient)this.configurationValuesService.getCBSConnectivityDetails().get(apikey);
    }

    private void genarateDuplicateMRNValue(PIMessageGeneratorDTO messageGeneratorDTO, String apiKey) {
        MessageStatus prasentValue = new MessageStatus(PIHeaderRejectionCode.MRN_NUMBER_ALREADY_EXISTS.getRejectionCode(), PIHeaderRejectionCode.MRN_NUMBER_ALREADY_EXISTS.getRejectionReason());
        this.genarateMessageStatus(messageGeneratorDTO, prasentValue, apiKey);
    }

    private void genarateMessageStatus(PIMessageGeneratorDTO messageGeneratorDTO, MessageStatus prasentValue, String apiKey) {
        messageGeneratorDTO.getMessageStatus().add(prasentValue);
        this.generateAndSendProcessStatusMessage(messageGeneratorDTO, apiKey);
        String mrn = "01";
        if (messageGeneratorDTO.getMessageStatus() != null && messageGeneratorDTO.getMessageStatus().size() > 0) {
            mrn = ((MessageStatus)messageGeneratorDTO.getMessageStatus().get(messageGeneratorDTO.getMessageStatus().size() - 1)).getmRNOfSourceMessage();
        }
    }

    private String generateInvalidIPAddressMessage(PIMessageGeneratorDTO messageGeneratorDTO, String apiKey) {
        MessageStatus prasentValue = new MessageStatus(PIHeaderRejectionCode.INVALID_MESSAGE_TYPE_IS_RECEIVED_FROM_THIS_IP_ADDRESS.getRejectionCode(), PIHeaderRejectionCode.INVALID_MESSAGE_TYPE_IS_RECEIVED_FROM_THIS_IP_ADDRESS.getRejectionReason());
        this.genarateMessageStatus(messageGeneratorDTO, prasentValue, apiKey);
        return this.generateAndGetAckMessage(apiKey, messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo(), this.configurationValuesService.getHubToBisencryptionRequired().booleanValue());
    }

    private void generateAndSendProcessStatusMessage(PIMessageGeneratorDTO messageGeneratorDTO, String apiKey) {
        Message processStatusMessage = this.messageGenerationService.generateAndGetProcessStatusMessage(PISharedFunctions.getDateStringFromGivenLocalDateAndFormat((String)MessageValues.sDateFormat, (LocalDate)PISharedValues.businessDate), PISharedValues.membershipId, RejectionLevelLookup.MESSAGE_LEVEL.getCode(), messageGeneratorDTO.getMessageStatus());
        String messageString = this.messageGenerationService.formAndGetMessage(apiKey, processStatusMessage, this.configurationValuesService.getHubToBisencryptionRequired());
        this.sendMessageToCBS(processStatusMessage.getHeader().getMessageReferenceNo(), processStatusMessage.getHeader().getOriginatingTimestamp(), apiKey, messageString);
    }

    private String processCBSMessage(Message message, String apiKey) {
        String returnValue = "";
        CBSClient cbsClient = (CBSClient)this.configurationValuesService.getCBSConnectivityDetails().get(message.getHeader().getMessageType());
        if (message.getHeader().getMessageType().equals(PIMessageTypes.AD01.toString())) {
            this.log.info("Ack message received from " + apiKey);
            this.cbsMessagingService.insertAckReceivedMap(cbsClient.getApiKey(), Boolean.valueOf(true));
        } else if (message.getHeader().getMessageType().equals(PIMessageTypes.AD02.toString())) {
            this.log.info("Resend message received from " + apiKey);
            this.processResendMessage(message, apiKey);
            returnValue = this.generateAndGetAckMessage(apiKey, message.getHeader().getMessageReferenceNo(), this.configurationValuesService.getHubToBisencryptionRequired().booleanValue());
        } else if (!this.configurationValuesService.getHubProtocol().equals(PIProtocols.NONE.toString())) {
            this.log.info("message received from " + apiKey + ", Msgtype - " + message.getHeader().getMessageType());
            String messageString = this.messageGenerationService.formAndGetMessage("PI", message, this.configurationValuesService.getEncryptionRequired());
            this.sendMessageToPI(message.getHeader().getMessageReferenceNo(), message.getHeader().getOriginatingTimestamp(), messageString);
            returnValue = this.generateAndGetAckMessage(apiKey, message.getHeader().getMessageReferenceNo(), this.configurationValuesService.getHubToBisencryptionRequired().booleanValue());
            this.log.info("Message sent to PI " + message.getHeader().getMessageType() + ", " + message.getHeader().getMessageReferenceNo());
        }
        return returnValue;
    }

    private String generateAndGetAckMessage(String sender, String mrnOfSourceMessage, boolean encryptionRequired) {
        Message ackMessage = this.messageGenerationService.generateAndGetAckMessage(mrnOfSourceMessage);
        return this.messageGenerationService.formAndGetMessage(sender, ackMessage, Boolean.valueOf(encryptionRequired));
    }

    private void sendMessageToCBS(String messageReferenceNo, String originatingTimeStamp, String apiKey, String message) {
        try {
            this.log.info("Outgoing Message - " + message);
            if (message != null && !message.isEmpty()) {
                this.cbsMessagingService.sendMessage(messageReferenceNo, originatingTimeStamp, message, apiKey);
                this.log.info("Message sent to BIS " + messageReferenceNo);
            }
        }
        catch (Exception e) {
            this.log.error("sendMessageToBIS - Exception : " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private void processResendMessage(Message message, String apiKey) {
        ResendAfterTimestampMessage resendMessageBodyObj = new ResendAfterTimestampMessage();
        resendMessageBodyObj = (ResendAfterTimestampMessage)message.getBody();
        this.log.info("Resend asked from " + resendMessageBodyObj.getTimestamp());
        Date resultDate = PISharedFunctions.parseAndGetDateFromGivenStringAndFormat((String)resendMessageBodyObj.getTimestamp(), (String)MessageValues.sOriginatingTimeStampFormat);
        try {
            List resultList = this.getMessagesAfterGivenDateTime(resultDate, apiKey);
            this.sendResendMessagesListOut(resultList, message.getHeader().getMessageReferenceNo(), apiKey);
        }
        catch (IOException e) {
            this.log.error("Error in processResendMessage : " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void sendResendMessagesListOut(List<PIQueueDTO> resultList, String inputMessageRefNo, String apiKey) {
        this.log.info("Send resend messages out to " + inputMessageRefNo + ", count -" + resultList.size());
        for (PIQueueDTO pIQueueDTO : resultList) {
            String filename = pIQueueDTO.getFileName();
            if (filename.equals("") || pIQueueDTO.getMessage().equals("")) continue;
            String[] contents = filename.split("_");
            this.sendMessageToCBS(contents[0], contents[1], apiKey, pIQueueDTO.getMessage());
        }
        this.log.info("Send resend messages out complete");
    }

    public List<PIQueueDTO> getMessagesAfterGivenDateTime(Date dateTime, String apiKey) throws IOException {
        File[] files;
        ArrayList<PIQueueDTO> returnValue = new ArrayList<PIQueueDTO>();
        String folderLocation = this.configurationValuesService.getPiCBSQueuedMessageAckedLocation(apiKey);
        for (File file : files = FileManipulationLibrary.getFilesOfGivenExtensionInGivenPath((String)folderLocation, (String)"txt")) {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            Date fileModifiedDateTime = new Date(attr.lastModifiedTime().toMillis());
            if (!fileModifiedDateTime.after(dateTime)) continue;
            String fileName = FilenameUtils.removeExtension((String)file.getName());
            byte[] fileContent = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
            returnValue.add(new PIQueueDTO(fileName, new String(fileContent)));
        }
        return returnValue;
    }

    public String processHTTPPIMessage(String message) {
        return this.processPIMessage(message);
    }

    private String processPIMessage(String messageString) {
        String returnValue = "";
        PISharedValues.p_Destination = "PI";
        try {
            this.log.info("Incoming Message - " + messageString);
            PIMessageGeneratorDTO messageGeneratorDTO = this.messageGenerationService.parseAndGetMessage(SourceType.PI.toString(), messageString, this.configurationValuesService.getEncryptionRequired());
            if (messageGeneratorDTO.getMessageStatus() == null || messageGeneratorDTO.getMessageStatus().size() == 0) {
                if (messageGeneratorDTO.getMessage().getHeader().getMessageType().equals(PIMessageTypes.AD03.toString())) {
                    this.log.info("Heart beat message received from " + PISharedValues.p_Destination);
                } else if (!this.messageGenerationService.isMRNExists(messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo()).booleanValue()) {
                    returnValue = this.processPIMessage(messageGeneratorDTO.getMessage());
                    this.messageGenerationService.addMRN(messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo());
                } else {
                    this.log.info("MRN already exists. So send Ack " + messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo());
                }
                returnValue = this.generateAndGetAckMessage(PISharedValues.p_Destination, messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo(), this.configurationValuesService.getEncryptionRequired().booleanValue());
            } else {
                returnValue = this.generateAndGetAckMessage(PISharedValues.p_Destination, "01", this.configurationValuesService.getEncryptionRequired().booleanValue());
            }
        }
        catch (Exception ex) {
            this.log.error("Error while processing PI message - " + ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
        if (!returnValue.isEmpty()) {
            this.log.info("Outgoing Message - " + returnValue);
        }
        return returnValue;
    }

    private String checkAndGetCBSDetail(PIMessageGeneratorDTO messageGeneratorDTO, String value) {
        CBSClient cbsClient = this.getCBSConnectivityDetail(value);
        String getApiKey = cbsClient.getApiKey();
        messageGeneratorDTO.getMessage().getHeader().setMessageReferenceNo(messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo() + "_" + getApiKey);
        String returnValue = this.processPIMessage(messageGeneratorDTO.getMessage());
        return returnValue;
    }

    private String processPIMessage(Message message) {
        String returnValue = "";
        String apiKey = "";
        this.log.info("Message received from " + PISharedValues.p_Destination + " , Msgtype - " + message.getHeader().getMessageType());
        if (!this.configurationValuesService.getHubProtocol().equals(PIProtocols.NONE.toString())) {
            String messageType = message.getHeader().getMessageType();
            apiKey = MessageProcessingService.getApiKey((Message)message, (String)messageType, (String)apiKey);
            String messageString = this.messageGenerationService.formAndGetMessage(apiKey, message, this.configurationValuesService.getHubToBisencryptionRequired());
            this.sendMessageToCBS(message.getHeader().getMessageReferenceNo(), message.getHeader().getOriginatingTimestamp(), apiKey, messageString);
            returnValue = this.generateAndGetAckMessage(PISharedValues.p_Destination, message.getHeader().getMessageReferenceNo(), this.configurationValuesService.getEncryptionRequired().booleanValue());
        }
        return returnValue;
    }

    private static String getApiKey(Message message, String messageType, String apiKey) {
        if (messageType.equals(PIMessageTypes.FX05.toString()) || messageType.equals(PIMessageTypes.FX07.toString())) {
            apiKey = PISharedValues.tradeApiKey;
        } else if (messageType.equals(PIMessageTypes.FX06.toString())) {
            if (message.getBody().getIsRepeatingBlock().booleanValue()) {
                apiKey = (String)SharedValues.processedMessageReferenceNumbersAndAPIKey.get(((RepeatingBlock)message.getBody().getRepeativeBlocks().get(0)).getSourceMessageReferenceNumber());
            }
        } else {
            apiKey = (String)SharedValues.processedMessageReferenceNumbersAndAPIKey.get(message.getHeader().getMessageReferenceNo());
        }
        return apiKey;
    }

    public void sendMessageToPI(String messageReferenceNo, String originatingTimeStamp, String message) {
        try {
            if (message != null && !message.isEmpty()) {
                this.piMessagingService.sendMessage(messageReferenceNo, originatingTimeStamp, message);
            }
        }
        catch (Exception e) {
            this.log.error("sendData - Exception : " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public String processHTTPPIResponseMessage(String responseString) {
        return this.processPIResponseMessage(responseString);
    }

    private String processPIResponseMessage(String messageString) {
        String returnValue = "";
        if (messageString != null && !messageString.isEmpty()) {
            PIMessageGeneratorDTO messageGeneratorDTO = this.messageGenerationService.parseAndGetMessage(SourceType.PI.toString(), messageString, this.configurationValuesService.getEncryptionRequired());
            if (messageGeneratorDTO.getMessageStatus() == null || messageGeneratorDTO.getMessageStatus().size() == 0) {
                if (messageGeneratorDTO.getMessage().getHeader().getMessageType().equals(PIMessageTypes.AD03.toString())) {
                    this.log.info("Heart beat message received from " + PISharedValues.p_Destination);
                } else if (!this.messageGenerationService.isMRNExists(messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo()).booleanValue()) {
                    returnValue = this.processPIResponseMessage(messageGeneratorDTO.getMessage());
                    this.messageGenerationService.addMRN(messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo());
                } else {
                    this.log.info("MRN already exists. So send Ack " + messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo());
                    returnValue = this.generateAndGetAckMessage(PISharedValues.p_Destination, messageGeneratorDTO.getMessage().getHeader().getMessageReferenceNo(), this.configurationValuesService.getEncryptionRequired().booleanValue());
                }
            } else {
                returnValue = this.generateAndGetAckMessage(PISharedValues.p_Destination, "01", this.configurationValuesService.getEncryptionRequired().booleanValue());
            }
        }
        return returnValue;
    }

    private String processPIResponseMessage(Message message) {
        String returnValue = "";
        if (message.getHeader().getMessageType().equals(PIMessageTypes.AD01.toString())) {
            this.log.info("PI Ack message received from " + PISharedValues.p_Destination);
            this.piMessagingService.setIsPIAckReceived(Boolean.valueOf(true));
        } else if (message.getHeader().getMessageType().equals(PIMessageTypes.AD02.toString())) {
            this.log.info("PI  Resend message received from " + PISharedValues.p_Destination);
        } else if (message.getHeader().getMessageType().equals(PIMessageTypes.FX05.toString())) {
            this.log.info("PI  Trade Response message received from " + PISharedValues.p_Destination);
            returnValue = this.generateAndGetAckMessage(PISharedValues.p_Destination, message.getHeader().getMessageReferenceNo(), this.configurationValuesService.getEncryptionRequired().booleanValue());
        } else if (message.getHeader().getMessageType().equals(PIMessageTypes.FX07.toString())) {
            this.log.info("PI Trade Recon message received from " + PISharedValues.p_Destination);
            returnValue = this.generateAndGetAckMessage(PISharedValues.p_Destination, message.getHeader().getMessageReferenceNo(), this.configurationValuesService.getEncryptionRequired().booleanValue());
        } else {
            this.log.info("PI Message received from " + PISharedValues.p_Destination + " , Msgtype - " + message.getHeader().getMessageType());
            returnValue = this.generateAndGetAckMessage(PISharedValues.p_Destination, message.getHeader().getMessageReferenceNo(), this.configurationValuesService.getEncryptionRequired().booleanValue());
        }
        return returnValue;
    }

    public void processHTTPCBSResponseMessage(String messageString, String apiKey) {
        PIMessageGeneratorDTO messageGeneratorDTO;
        if (messageString != null && !messageString.isEmpty() && ((messageGeneratorDTO = this.messageGenerationService.parseAndGetMessage(apiKey, messageString, this.configurationValuesService.getHubToBisencryptionRequired())).getMessageStatus() == null || messageGeneratorDTO.getMessageStatus().isEmpty())) {
            if (messageGeneratorDTO.getMessage().getHeader().getMessageType().equals(PIMessageTypes.AD03.toString())) {
                this.log.info("Heart beat message received from " + PISharedValues.p_Destination);
            } else if (messageGeneratorDTO.getMessage().getHeader().getMessageType().equals(PIMessageTypes.AD01.toString())) {
                this.log.info("Ack message received from " + PISharedValues.p_Destination);
                this.cbsMessagingService.insertAckReceivedMap(apiKey, Boolean.valueOf(true));
            } else if (messageGeneratorDTO.getMessage().getHeader().getMessageType().equals(PIMessageTypes.AD02.toString())) {
                this.log.info("Resend message received from " + PISharedValues.p_Destination);
            }
        }
    }
}

