/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.shared;

import com.cspl.fxretailhub.service.ConfigurationValuesService;
import com.cspl.library.FileManipulationLibrary;
import com.cspl.pi.message.shared.MessageValues;
import com.cspl.pi.shared.IPIBondingChild;
import com.cspl.pi.shared.PISharedFunctions;
import com.cspl.pi.shared.PISharedValues;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIBondingChild
implements IPIBondingChild {
    private Logger log = LoggerFactory.getLogger(PIBondingChild.class);
    private ConfigurationValuesService configurationValuesService;

    public PIBondingChild(ConfigurationValuesService configurationValuesService) {
        this.configurationValuesService = configurationValuesService;
    }

    public String getBankMembershipID() {
        return PISharedValues.membershipId;
    }

    public void logError(Exception ex) {
        this.log.error(ExceptionUtils.getFullStackTrace((Throwable)ex));
    }

    public String getProcessedMRNFileName() {
        return this.configurationValuesService.getPiProcessedMRNFileName();
    }

    public Integer getMessageReferenceNoSequenceLength() {
        return 6;
    }

    public String getMessageReferenceNoSourceIdentiferTag() {
        return "H";
    }

    public Long updateAndGetMRNSequence(String participantCode) {
        String fileName = PISharedFunctions.getDateStringInGivenFormat((String)MessageValues.sDateFormat) + "_" + this.configurationValuesService.getPiMRNFileName();
        try {
            this.checkAndResetMRNCounter(participantCode, fileName);
            if (!PISharedValues.currentMRN.containsKey(participantCode)) {
                PISharedValues.currentMRN.put(participantCode, this.checkAndGetMRNCounter(fileName));
            }
            PISharedValues.currentMRN.put(participantCode, (Long)PISharedValues.currentMRN.get(participantCode) + 1L);
            FileManipulationLibrary.writeOverrideFile((String)fileName, (String)((Long)PISharedValues.currentMRN.get(participantCode)).toString());
        }
        catch (Exception ex) {
            this.log.error("Error which getting MRN counter for " + participantCode + " - " + ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
        return (Long)PISharedValues.currentMRN.get(participantCode);
    }

    private void checkAndResetMRNCounter(String participantCode, String fileName) {
        try {
            if (!Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
                File[] existingFiles;
                if (PISharedValues.currentMRN.containsKey(participantCode)) {
                    PISharedValues.currentMRN.remove(participantCode);
                }
                for (File file : existingFiles = FileManipulationLibrary.getFilesOfGivenExtensionAndContainingNameInGivenPath((String)System.getProperty("user.dir"), (String)FilenameUtils.removeExtension((String)this.configurationValuesService.getPiMRNFileName()), (String)"txt")) {
                    FileManipulationLibrary.checkAndDeleteFile((String)file.getAbsolutePath());
                }
            }
        }
        catch (Exception ex) {
            this.log.error("Error on reset MRN counter - " + ExceptionUtils.getFullStackTrace((Throwable)ex));
        }
    }

    public Long checkAndGetMRNCounter(String fileName) {
        Long returnValue = 0L;
        if (Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            returnValue = Integer.parseInt((String)FileManipulationLibrary.readFileAsList((String)fileName).get(0));
        }
        return returnValue;
    }

    public Boolean isValidateMRN() {
        return true;
    }
}

