/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.cbs.service;

import com.cspl.fxretailhub.cbs.service.CBSMessagingService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.fxretailhub.shared.CBSClient;
import com.cspl.pi.services.dto.PIQueueDTO;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CBSMessageSendingService {
    private Logger log = LoggerFactory.getLogger(CBSMessageSendingService.class);
    @Value(value="${ccilfx.hub.ackCheckIntevalInMilliSec}")
    private String ackCheckIntevalInMilliSec;
    @Value(value="${ccilfx.hub.ackCheckRetryCount}")
    private String ackCheckRetryCount;
    private ICommunicationInterface communicationInterface;

    public void initialise(ICommunicationInterface communicationInterface) {
        this.communicationInterface = communicationInterface;
    }

    public boolean checkAckAndSendMessage(CBSMessagingService cbsMessagingService, PIQueueDTO message, CBSClient client) throws IOException {
        try {
            this.log.info("Ack received status from BIS is - " + cbsMessagingService.getAckReceivedMap(client.getApiKey()));
            Integer ackCheckAttemptCount = 0;
            cbsMessagingService.insertAckReceivedMap(client.getApiKey(), Boolean.valueOf(false));
            boolean sendSuccess = this.sendMessage(message.getMessage(), client);
            if (!sendSuccess) {
                cbsMessagingService.insertAckReceivedMap(client.getApiKey(), Boolean.valueOf(true));
            } else {
                this.log.info("Message sent waiting for ack from " + client.getApiKey());
            }
            while (!cbsMessagingService.getAckReceivedMap(client.getApiKey()).booleanValue()) {
                if ((ackCheckAttemptCount = Integer.valueOf(ackCheckAttemptCount + 1)) > Integer.parseInt(this.ackCheckRetryCount)) {
                    sendSuccess = false;
                    this.log.info("Ack not received from " + client.getApiKey());
                    break;
                }
                Thread.sleep(Integer.parseInt(this.ackCheckIntevalInMilliSec));
            }
            if (sendSuccess) {
                this.log.info("Ack received from " + client.getApiKey());
            }
            return sendSuccess;
        }
        catch (Exception e) {
            this.log.error("send message failure from " + client.getApiKey() + "- Exception : " + e);
            return false;
        }
    }

    public synchronized boolean sendMessage(String message, CBSClient client) {
        String destinationBIS = client.getIpaddress() + ":" + client.getPort();
        try {
            this.log.info("Send message begin to " + destinationBIS);
            boolean sendSuccess = false;
            sendSuccess = this.communicationInterface.sendMessage(message, client);
            this.log.info("Send message to " + destinationBIS + " complete");
            return sendSuccess;
        }
        catch (Exception e) {
            this.log.error("send message to - " + destinationBIS + " - Exception : " + e);
            return false;
        }
    }
}

