/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.cbs.service;

import com.cspl.fxretailhub.cbs.service.CBSMessageSendingService;
import com.cspl.fxretailhub.cbs.service.thread.CBSMessageSendingThread;
import com.cspl.fxretailhub.service.ConfigurationValuesService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.fxretailhub.shared.CBSClient;
import com.cspl.library.FileManipulationLibrary;
import com.cspl.pi.services.dto.PIQueueDTO;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CBSMessagingService {
    @Inject
    private CBSMessageSendingService messageSendingService;
    @Inject
    private ConfigurationValuesService configurationValuesService;
    private static final ReentrantReadWriteLock reentrantLock = new ReentrantReadWriteLock();
    private HashMap<String, Queue<PIQueueDTO>> bisWiseQueue = new HashMap();
    private HashMap<String, Boolean> isAckReceived = new HashMap();
    private Logger log = LoggerFactory.getLogger(CBSMessagingService.class);

    public void initialise(ICommunicationInterface communicationInterface) {
        this.messageSendingService.initialise(communicationInterface);
        for (Map.Entry entry : this.configurationValuesService.getCBSConnectivityDetails().entrySet()) {
            CBSMessageSendingThread messageSendingThread = new CBSMessageSendingThread(this, this.messageSendingService, communicationInterface, (CBSClient)entry.getValue());
            messageSendingThread.start();
            this.fetchAndProcessUnSentMessages(((CBSClient)entry.getValue()).getApiKey());
        }
    }

    public HashMap<String, Boolean> getIsAckReceived() {
        return this.isAckReceived;
    }

    public void setIsAckReceived(HashMap<String, Boolean> isAckReceived) {
        this.isAckReceived = isAckReceived;
    }

    public HashMap<String, Queue<PIQueueDTO>> getBisWiseQueue() {
        return this.bisWiseQueue;
    }

    public void setBisWiseQueue(HashMap<String, Queue<PIQueueDTO>> bisWiseQueue) {
        this.bisWiseQueue = bisWiseQueue;
    }

    public void fetchAndProcessUnSentMessages(String apiKey) {
        try {
            File[] files;
            for (File file : files = FileManipulationLibrary.getFilesOfGivenExtensionInGivenPath((String)this.configurationValuesService.getPiCBSQueuedMessageOutboxLocationForClient(apiKey), (String)"txt")) {
                String fileName = FilenameUtils.removeExtension((String)file.getName());
                byte[] fileContent = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
                this.putMessageIntoCBSQueue(apiKey, new PIQueueDTO(fileName, new String(fileContent)));
            }
        }
        catch (Exception ex) {
            this.log.error("Error while fetching unprocessed messages for {0} - {1}" + apiKey, (Object)ex.getMessage());
        }
    }

    public void insertAckReceivedMap(String key, Boolean status) {
        this.isAckReceived.put(key, status);
    }

    public void sendMessage(String messageReferenceNo, String originatingTimeStamp, String messageString, String apiKey) throws IOException {
        String fileName = messageReferenceNo + "_" + originatingTimeStamp;
        PIQueueDTO message = new PIQueueDTO(fileName, messageString);
        this.persistPIMessage(message, apiKey);
        this.putMessageIntoCBSQueue(apiKey, message);
    }

    private void persistPIMessage(PIQueueDTO message, String apiKey) throws IOException {
        String fileLocation = this.configurationValuesService.getPiCBSQueuedMessageOutboxLocation(apiKey) + "/" + message.getFileName() + ".txt";
        Files.write(Paths.get(fileLocation, new String[0]), message.getMessage().getBytes(), new OpenOption[0]);
    }

    public void updateSentStatus(PIQueueDTO message, String apiKey) {
        String sourcePath = this.configurationValuesService.getPiCBSQueuedMessageOutboxLocation(apiKey) + "/" + message.getFileName() + ".txt";
        try {
            String destinationPath = this.configurationValuesService.getPiCBSQueuedMessageAckedLocation(apiKey) + "/" + message.getFileName() + ".txt";
            FileManipulationLibrary.moveFile((String)sourcePath, (String)destinationPath);
        }
        catch (IOException e) {
            try {
                FileManipulationLibrary.checkAndDeleteFile((String)sourcePath);
            }
            catch (IOException exception) {
                this.log.error("Error in updateSentStatus : " + exception.getMessage());
            }
            this.log.error("Error while update sent status - " + message.getFileName() + " - Exception : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMessageIntoCBSQueue(String bisApiKey, PIQueueDTO message) {
        reentrantLock.writeLock().lock();
        try {
            if (!this.bisWiseQueue.containsKey(bisApiKey)) {
                this.bisWiseQueue.put(bisApiKey, new LinkedList());
            }
            Queue queue = (Queue)this.bisWiseQueue.get(bisApiKey);
            queue.add(message);
            this.bisWiseQueue.put(bisApiKey, queue);
        }
        finally {
            reentrantLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIQueueDTO checkAndGetMessageFromCBSQueue(String apiKey) {
        PIQueueDTO queueDTO;
        reentrantLock.readLock().lock();
        try {
            if (!this.bisWiseQueue.containsKey(apiKey)) {
                Object defualtQueue = null;
                PIQueueDTO pIQueueDTO = defualtQueue;
                return pIQueueDTO;
            }
            if (((Queue)this.bisWiseQueue.get(apiKey)).isEmpty()) {
                Object defualtQueue = null;
                PIQueueDTO pIQueueDTO = defualtQueue;
                return pIQueueDTO;
            }
            queueDTO = (PIQueueDTO)((Queue)this.bisWiseQueue.get(apiKey)).poll();
        }
        finally {
            reentrantLock.readLock().unlock();
        }
        return queueDTO;
    }

    public Boolean getAckReceivedMap(String apiKey) {
        return (Boolean)this.isAckReceived.get(apiKey);
    }
}

