/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.library;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileManipulationLibrary {
    private static final Logger log = LoggerFactory.getLogger(FileManipulationLibrary.class);
    private static final List<AclEntryPermission> COMMON_PERMISSIONS = Arrays.asList(AclEntryPermission.READ_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_ACL, AclEntryPermission.SYNCHRONIZE);
    private static final List<AclEntryPermission> OWNER_ADDITIONAL_PERMISSIONS = Arrays.asList(AclEntryPermission.WRITE_DATA, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_ACL, AclEntryPermission.WRITE_OWNER);
    private static final List<AclEntryPermission> OTHERS_ADDITIONAL_PERMISSIONS = Arrays.asList(AclEntryPermission.DELETE);

    public static Properties readPropertyFile(String path) throws IOException {
        Properties returnValue = new Properties();
        FileInputStream file = new FileInputStream(path);
        returnValue.load(file);
        file.close();
        return returnValue;
    }

    public static void checkAndCreateDirectory(String directoryLocation) {
        File directory = new File(directoryLocation);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public static void writeFile(String location, String content) throws IOException {
        try (FileWriter file = new FileWriter(location, true);){
            file.write(content);
            file.flush();
        }
    }

    public static List<String> readFile(String location) {
        Path path = Paths.get(location, new String[0]);
        ArrayList<String> fileContent = new ArrayList();
        try {
            fileContent = Files.readAllLines(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileContent;
    }

    public static void writefile(FileWriter fileWriter, String content) throws IOException {
        fileWriter.write(content);
        fileWriter.flush();
    }

    public static List<String> readFile(Path filePath) throws IOException {
        ArrayList<String> fileContent = new ArrayList();
        fileContent = Files.readAllLines(filePath);
        return fileContent;
    }

    public static FileWriter getFileWriterForFile(String fileWithPath) throws IOException {
        FileWriter fileWriter = new FileWriter(fileWithPath, true);
        return fileWriter;
    }

    public static Path getFilePathForfile(String fileWithPath) throws IOException {
        return Paths.get(fileWithPath, new String[0]);
    }

    public static void deleteFile(String fileNameWithPath) {
        Path filePath = Paths.get(fileNameWithPath, new String[0]);
        try {
            Files.delete(filePath);
        }
        catch (IOException ioException) {
            log.error("! Error Caught In Deleting File As The File Is Not Present !" + ioException.getMessage());
        }
        catch (Exception e) {
            log.error("file delete error, {}", (Object)e.getMessage());
        }
    }

    public static FileWriter getFileWriterForFile(String fileWithPath, boolean appendMode) throws IOException {
        FileWriter fileWriter = new FileWriter(fileWithPath, appendMode);
        return fileWriter;
    }

    public static void setFilePermissions(Path path) throws IOException {
        String[] groupNames;
        AclFileAttributeView aclView;
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
        }
        if ((aclView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0])) == null) {
            throw new UnsupportedOperationException("ACL view not supported for this file");
        }
        ArrayList<AclEntry> aclEntries = new ArrayList<AclEntry>();
        UserPrincipal owner = aclView.getOwner();
        aclEntries.add(FileManipulationLibrary.createAclEntry((AclEntryType)AclEntryType.ALLOW, (UserPrincipal)owner, (List)FileManipulationLibrary.mergePermissions((List)OTHERS_ADDITIONAL_PERMISSIONS, (List)FileManipulationLibrary.mergePermissions((List)COMMON_PERMISSIONS, (List)OWNER_ADDITIONAL_PERMISSIONS))));
        for (String groupName : groupNames = new String[]{"SYSTEM", "Users", "Authenticated Users"}) {
            UserPrincipal principal = FileManipulationLibrary.getUserPrincipal((String)groupName);
            aclEntries.add(FileManipulationLibrary.createAclEntry((AclEntryType)AclEntryType.ALLOW, (UserPrincipal)principal, (List)COMMON_PERMISSIONS));
        }
        aclView.setAcl(aclEntries);
    }

    private static List<AclEntryPermission> mergePermissions(List<AclEntryPermission> basePermissions, List<AclEntryPermission> additionalPermissions) {
        HashSet<AclEntryPermission> mergedPermissions = new HashSet<AclEntryPermission>(basePermissions);
        mergedPermissions.addAll(additionalPermissions);
        return new ArrayList<AclEntryPermission>(mergedPermissions);
    }

    private static AclEntry createAclEntry(AclEntryType type, UserPrincipal principal, List<AclEntryPermission> permissions) throws IOException {
        return AclEntry.newBuilder().setType(type).setPrincipal(principal).setPermissions(permissions.toArray(new AclEntryPermission[0])).build();
    }

    private static UserPrincipal getUserPrincipal(String principalName) throws IOException {
        return FileSystems.getDefault().getUserPrincipalLookupService().lookupPrincipalByName(principalName);
    }
}

