/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.rest.resource;

import com.cspl.fxretailhub.service.MessageProcessingService;
import com.cspl.pi.shared.PISharedValues;
import jakarta.servlet.http.HttpServletRequest;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(name={"ccilfx.hub.protocol"}, havingValue="HTTP")
@RestController
@RequestMapping(value={"/hub"})
public class MessagingResource {
    @Inject
    private MessageProcessingService messageProcessingService;
    private Logger log = LoggerFactory.getLogger(MessagingResource.class);

    @PostMapping(value={"/send"})
    public ResponseEntity<String> send(@RequestBody String message, HttpServletRequest request) {
        if (request.getHeader("IP") != null && request.getHeader("PORT") != null && request.getHeader("APIKEY") != null) {
            this.log.info("Message received from " + request.getHeader("IP") + ":" + request.getHeader("PORT"));
            String returnMessage = this.messageProcessingService.processHTTPCBSMessage(message, request);
            return ResponseEntity.ok((Object)returnMessage);
        }
        return ResponseEntity.badRequest().body((Object)"Required header is missing");
    }

    @PostMapping(value={"/connect"})
    public String connect(@RequestBody String message, HttpServletRequest request) {
        this.log.info("Connection received from " + PISharedValues.p_Destination + ",host :" + message);
        return this.messageProcessingService.addActiveBISClient(message, request);
    }

    @PostMapping(value={"/message-from-pi"})
    public String getMessageFromPI(@RequestBody String message) {
        this.log.info("Message received from PI");
        return this.messageProcessingService.processHTTPPIMessage(message);
    }
}

