/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.service;

import com.cspl.fxretailhub.shared.CBSClient;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationValuesService {
    @Value(value="${ccilfx.hub.PFXDirectory}")
    private String pfxLocation;
    @Value(value="${ccilfx.hub.PFXPassword}")
    private String pfxPassword;
    @Value(value="${ccilfx.hub.CERDirectory}")
    private String cerLocation;
    @Value(value="${ccilfx.hub.participant}")
    private String participant;
    @Value(value="${ccilfx.hub.host}")
    private String host;
    @Value(value="${ccilfx.hub.port}")
    private String port;
    @Value(value="${ccilfx.hub.pi.encryptionRequired}")
    private Boolean encryptionRequired;
    @Value(value="${ccilfx.hub.bis.encryptionRequired}")
    private Boolean hubToBisencryptionRequired;
    @Value(value="${ccilfx.hub.protocol}")
    private String hubProtocol;
    @Value(value="${ccilfx.hub.queuedMessageLocation}")
    private String hubQueuedMessageLocation;
    @Value(value="${server.port}")
    private String serverPort;
    @Value(value="${ccilfx.hub.pi.host}")
    private String piHost;
    @Value(value="${ccilfx.hub.pi.port}")
    private String piPort;
    private String piMRNFileName = "";
    private String piProcessedMRNFileName = "";
    private Boolean isEnableRESTAPI = false;
    private Map<String, CBSClient> CBSConnectivityDetails;

    public Boolean getIsEnableRESTAPI() {
        return this.isEnableRESTAPI;
    }

    public void setIsEnableRESTAPI(Boolean isEnableRESTAPI) {
        this.isEnableRESTAPI = isEnableRESTAPI;
    }

    public String getHUBPIQueuedMessageLocation() {
        return this.getHUBQueuedMessageLocation() + "/PI";
    }

    public String getHUBQueuedMessageLocation() {
        return this.hubQueuedMessageLocation + "/HUB";
    }

    public String getPiCBSQueuedMessageOutboxLocation(String apiKey) {
        return this.getHUBQueuedMessageLocation() + "/" + apiKey + "/Outbox";
    }

    public String getPiCBSQueuedMessageOutboxLocationForClient(String apiKey) {
        return this.getPiCBSQueuedMessageOutboxLocation(apiKey);
    }

    public String getPiCBSQueuedMessageAckedLocation(String apiKey) {
        return this.getHUBQueuedMessageLocation() + "/" + apiKey + "/Acked";
    }

    public String getPiCBSQueuedMessageArchiveLocation(String apiKey) {
        return this.getHUBQueuedMessageLocation() + "/" + apiKey + "/Archived";
    }

    public String getHUBPIQueuedMessageOutboxLocation() {
        return this.getHUBPIQueuedMessageLocation() + "/Outbox";
    }

    public String getHUBPIQueuedMessageAckedLocation() {
        return this.getHUBPIQueuedMessageLocation() + "/Acked";
    }

    public String getHUBPIQueuedMessageArchiveLocation() {
        return this.getHUBPIQueuedMessageLocation() + "/Archived";
    }

    public String getHubQueuedMessageLocation() {
        return this.hubQueuedMessageLocation;
    }

    public void setHubQueuedMessageLocation(String hubQueuedMessageLocation) {
        this.hubQueuedMessageLocation = hubQueuedMessageLocation;
    }

    public String getPiMRNFileName() {
        return this.piMRNFileName;
    }

    public void setPiMRNFileName(String piMRNFileName) {
        this.piMRNFileName = piMRNFileName;
    }

    public String getPiProcessedMRNFileName() {
        return this.piProcessedMRNFileName;
    }

    public void setPiProcessedMRNFileName(String piProcessedMRNFileName) {
        this.piProcessedMRNFileName = piProcessedMRNFileName;
    }

    public Boolean getEncryptionRequired() {
        return this.encryptionRequired;
    }

    public void setEncryptionRequired(Boolean encryptionRequired) {
        this.encryptionRequired = encryptionRequired;
    }

    public Boolean getHubToBisencryptionRequired() {
        return this.hubToBisencryptionRequired;
    }

    public void setHubToBisencryptionRequired(Boolean hubToBisencryptionRequired) {
        this.hubToBisencryptionRequired = hubToBisencryptionRequired;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getPiPort() {
        return this.piPort;
    }

    public void setPiPort(String piPort) {
        this.piPort = piPort;
    }

    public String getHubProtocol() {
        return this.hubProtocol;
    }

    public void setHubProtocol(String hubProtocol) {
        this.hubProtocol = hubProtocol;
    }

    public String getPiHost() {
        return this.piHost;
    }

    public void setPiHost(String piHost) {
        this.piHost = piHost;
    }

    public String getPfxLocation() {
        return this.pfxLocation;
    }

    public String getPfxPassword() {
        return this.pfxPassword;
    }

    public void setPfxPassword(String pfxPassword) {
        this.pfxPassword = pfxPassword;
    }

    public String getCerLocation() {
        return this.cerLocation;
    }

    public String getParticipant() {
        return this.participant;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public Map<String, CBSClient> getCBSConnectivityDetails() {
        return this.CBSConnectivityDetails;
    }

    public void setCBSConnectivityDetails(Map<String, CBSClient> cBSConnectivityDetails) {
        this.CBSConnectivityDetails = cBSConnectivityDetails;
    }
}

