/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.service;

import com.cspl.api.services.dto.CertificateDTO;
import com.cspl.api.shared.SharedValues;
import com.cspl.fxretailhub.enumeration.BISClientValue;
import com.cspl.fxretailhub.enumeration.MRNFileValue;
import com.cspl.fxretailhub.enumeration.MessageType;
import com.cspl.fxretailhub.enumeration.PIProtocols;
import com.cspl.fxretailhub.service.ConfigurationValuesService;
import com.cspl.fxretailhub.shared.CBSClient;
import com.cspl.fxretailhub.shared.ClientArray;
import com.cspl.fxretailhub.shared.PIBondingChild;
import com.cspl.library.DateLibrary;
import com.cspl.library.FileManipulationLibrary;
import com.cspl.pi.shared.PIBondingMethods;
import com.cspl.pi.shared.PISharedValues;
import com.cspl.service.DigitalSignatureService;
import com.cspl.service.EncodingService;
import com.cspl.service.EncryptionService;
import com.cspl.service.dto.CertificateValidityDTO;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LookupService {
    @Inject
    private ConfigurationValuesService configurationValuesService;
    private Logger log = LoggerFactory.getLogger(LookupService.class);
    private PIBondingMethods piBondingMethods = new PIBondingMethods();
    @Value(value="${ccilfx.hub.bis.CBSConnectivityDetails}")
    private String CBSConnectivityDetails;

    public String getCBSConnectivityDetails() {
        return this.CBSConnectivityDetails;
    }

    public void initialiseLookup() throws Exception {
        try {
            this.log.info("Initialise lookup started");
            PIBondingMethods.bondingChild = new PIBondingChild(this.configurationValuesService);
            PISharedValues.membershipId = this.configurationValuesService.getParticipant();
            PISharedValues.businessDate = DateLibrary.getCurrentLocalDate();
            PISharedValues.p_Source = "HUB";
            PISharedValues.p_Destination = "PI";
            PISharedValues.currentMRN = new HashMap();
            PISharedValues.certificates = new HashMap();
            ClientArray.setClientDetail(new HashMap());
            this.readAndStoreCBSConnectivityDetails();
            this.configurationValuesService.setPiMRNFileName("MRN_PIToBIS.txt");
            this.configurationValuesService.setPiProcessedMRNFileName("Processed_BIS_MRN.txt");
            SharedValues.processedMessageReferenceNumbersAndAPIKey = this.getProcessedMessageReferenceNo();
            PISharedValues.processedMessageReferenceNumbers = new ArrayList();
            if (!this.configurationValuesService.getHubProtocol().equals(PIProtocols.NONE.toString())) {
                if (this.configurationValuesService.getEncryptionRequired().booleanValue()) {
                    PISharedValues.certificates.put(PISharedValues.p_Source, this.checkAndGetPFXInformations(this.configurationValuesService.getPfxLocation(), this.configurationValuesService.getPfxPassword()));
                    PISharedValues.certificates.put(PISharedValues.p_Destination, this.checkAndGetCERInformations(this.configurationValuesService.getCerLocation()));
                }
                this.checkAndCreateQueuedMessageLogFolders();
            }
            this.configurationValuesService.setPfxPassword(null);
            this.log.info("Initialise lookup complete");
        }
        catch (Exception ex) {
            this.log.error("Error in initialise lookup - " + ex.getMessage());
            throw ex;
        }
    }

    private void checkAndCreateQueuedMessageLogFolders() {
        FileManipulationLibrary.checkAndCreateDirectory((String)this.configurationValuesService.getHUBQueuedMessageLocation());
        FileManipulationLibrary.checkAndCreateDirectory((String)this.configurationValuesService.getHUBPIQueuedMessageLocation());
        FileManipulationLibrary.checkAndCreateDirectory((String)this.configurationValuesService.getHUBPIQueuedMessageOutboxLocation());
        FileManipulationLibrary.checkAndCreateDirectory((String)this.configurationValuesService.getHUBPIQueuedMessageAckedLocation());
        FileManipulationLibrary.checkAndCreateDirectory((String)this.configurationValuesService.getHUBPIQueuedMessageArchiveLocation());
        for (Map.Entry entry : this.configurationValuesService.getCBSConnectivityDetails().entrySet()) {
            this.checkAndCreateCBSDirectory(((CBSClient)entry.getValue()).getApiKey());
        }
    }

    private void checkAndCreateCBSDirectory(String apiKey) {
        FileManipulationLibrary.checkAndCreateDirectory((String)(this.configurationValuesService.getHUBQueuedMessageLocation() + "/" + apiKey));
        FileManipulationLibrary.checkAndCreateDirectory((String)this.configurationValuesService.getPiCBSQueuedMessageOutboxLocation(apiKey));
        FileManipulationLibrary.checkAndCreateDirectory((String)this.configurationValuesService.getPiCBSQueuedMessageAckedLocation(apiKey));
        FileManipulationLibrary.checkAndCreateDirectory((String)this.configurationValuesService.getPiCBSQueuedMessageArchiveLocation(apiKey));
    }

    private List<String> getProcessedCBSMessageReferenceNo() throws IOException {
        List<String> returnValue = Files.exists(Paths.get(this.configurationValuesService.getPiProcessedMRNFileName(), new String[0]), new LinkOption[0]) ? Files.readAllLines(Paths.get(this.configurationValuesService.getPiProcessedMRNFileName(), new String[0])) : new ArrayList<String>();
        return returnValue;
    }

    private HashMap<String, String> getProcessedMessageReferenceNo() throws IOException {
        HashMap<String, String> messageReferenceNoAndAPIKye = new HashMap<String, String>();
        if (Files.exists(Paths.get(this.piBondingMethods.getProcessedMRNFileName(), new String[0]), new LinkOption[0])) {
            List<String> returnValue = Files.readAllLines(Paths.get(this.piBondingMethods.getProcessedMRNFileName(), new String[0]));
            for (String value : returnValue) {
                String[] splitReturnValue = value.split("_");
                if (splitReturnValue.length < 2) continue;
                messageReferenceNoAndAPIKye.put(splitReturnValue[MRNFileValue.MRN.getNumVal()], splitReturnValue[MRNFileValue.APIKey.getNumVal()]);
            }
        }
        return messageReferenceNoAndAPIKye;
    }

    private CertificateDTO checkAndGetPFXInformations(String location, String pfxPassword) throws Exception {
        File[] pfxFiles = FileManipulationLibrary.getFilesOfGivenExtensionInGivenPath((String)location, (String)"pfx");
        DigitalSignatureService digitalSignatureService = new DigitalSignatureService();
        LocalDate currentDate = DateLibrary.getCurrentLocalDate();
        Date currentLowerIssueDate = new Date();
        CertificateDTO certificateDTO = null;
        EncodingService encodingService = new EncodingService();
        String decryptedPassword = EncryptionService.decryptToString((byte[])encodingService.decodeStringToByteArray(pfxPassword));
        for (File pfxFile : pfxFiles) {
            try {
                byte[] certificateContent = Files.readAllBytes(Paths.get(pfxFile.getPath(), new String[0]));
                CertificateValidityDTO certificateValidityDTO = digitalSignatureService.getCertificateValidity(certificateContent, decryptedPassword);
                if (!DateLibrary.isGivenDateBetweenFromAndToDates((LocalDate)currentDate, (Date)certificateValidityDTO.getIssueDate(), (Date)certificateValidityDTO.getExpiryDate()).booleanValue() || !currentLowerIssueDate.after(certificateValidityDTO.getIssueDate())) continue;
                currentLowerIssueDate = certificateValidityDTO.getIssueDate();
                certificateDTO = new CertificateDTO();
                certificateDTO.setPrivateKey(digitalSignatureService.getPrivateKey(certificateContent, decryptedPassword));
                certificateDTO.setPublicKey(digitalSignatureService.getPublicKey(certificateContent, decryptedPassword));
                certificateDTO.setIssueDate(certificateValidityDTO.getIssueDate());
                certificateDTO.setExpiryDate(certificateValidityDTO.getExpiryDate());
            }
            catch (Exception ex) {
                this.log.error("PFX information fetch error - " + pfxFile.getPath() + " - Exception - " + ex.getMessage());
            }
        }
        return certificateDTO;
    }

    private CertificateDTO checkAndGetCERInformations(String location) {
        File[] pfxFiles = FileManipulationLibrary.getFilesOfGivenExtensionInGivenPath((String)location, (String)"cer");
        DigitalSignatureService digitalSignatureService = new DigitalSignatureService();
        LocalDate currentDate = DateLibrary.getCurrentLocalDate();
        Date currentLowerIssueDate = new Date();
        CertificateDTO certificateDTO = null;
        for (File pfxFile : pfxFiles) {
            try {
                byte[] certificateContent = Files.readAllBytes(Paths.get(pfxFile.getPath(), new String[0]));
                CertificateValidityDTO certificateValidityDTO = digitalSignatureService.getCertificateValidity(certificateContent, null);
                if (!DateLibrary.isGivenDateBetweenFromAndToDates((LocalDate)currentDate, (Date)certificateValidityDTO.getIssueDate(), (Date)certificateValidityDTO.getExpiryDate()).booleanValue() || !currentLowerIssueDate.after(certificateValidityDTO.getIssueDate())) continue;
                currentLowerIssueDate = certificateValidityDTO.getIssueDate();
                certificateDTO = new CertificateDTO();
                certificateDTO.setPrivateKey(digitalSignatureService.getPrivateKey(certificateContent, null));
                certificateDTO.setPublicKey(digitalSignatureService.getPublicKey(certificateContent, null));
                certificateDTO.setIssueDate(certificateValidityDTO.getIssueDate());
                certificateDTO.setExpiryDate(certificateValidityDTO.getExpiryDate());
            }
            catch (Exception ex) {
                this.log.error("CER information fetch error - " + pfxFile.getPath() + " - Exception - " + ex.getMessage());
            }
        }
        return certificateDTO;
    }

    public void readAndStoreCBSConnectivityDetails() {
        HashMap<String, CBSClient> cbsClientValues = new HashMap<String, CBSClient>();
        String[] splitValues = this.CBSConnectivityDetails.split(";");
        if (splitValues.length == 5) {
            for (String value : splitValues) {
                String[] cbsValue = value.split("#");
                String apiKey = cbsValue[BISClientValue.apiKey.getNumVal()];
                String messageType = cbsValue[BISClientValue.messageType.getNumVal()];
                String cerDirectory = cbsValue[BISClientValue.cerDirectory.getNumVal()];
                if (cbsValue.length >= 3 && (messageType.equals(MessageType.Trades.name()) || messageType.equals(MessageType.SwapQuotes.name()) || messageType.equals(MessageType.Markup.name()) || messageType.equals(MessageType.Limits.name()) || messageType.equals(MessageType.CustomerApproval.name()))) {
                    if (messageType.equals(MessageType.Trades.name())) {
                        PISharedValues.tradeApiKey = cbsValue[BISClientValue.apiKey.getNumVal()];
                    }
                    if (!cbsClientValues.containsKey(apiKey)) {
                        cbsClient = new CBSClient(cbsValue[BISClientValue.ipaddress.getNumVal()], cbsValue[BISClientValue.apiKey.getNumVal()], cbsValue[BISClientValue.port.getNumVal()], cbsValue[BISClientValue.messageType.getNumVal()], cbsValue[BISClientValue.cerDirectory.getNumVal()]);
                        LookupService.addAllowedMessageTypes((String)messageType, (CBSClient)cbsClient);
                        cbsClientValues.put(apiKey, cbsClient);
                        if (this.configurationValuesService.getHubToBisencryptionRequired().booleanValue()) {
                            PISharedValues.certificates.put(apiKey, this.checkAndGetCERInformations(cerDirectory));
                        }
                    } else {
                        cbsClient = (CBSClient)cbsClientValues.get(apiKey);
                        LookupService.addAllowedMessageTypes((String)messageType, (CBSClient)cbsClient);
                    }
                    this.log.info("stored CBS Client Values : " + messageType);
                    continue;
                }
                String errerValue = "Invalid CBS Message Type Connectivity Details";
                this.displayErrorAndClose(errerValue);
            }
            this.configurationValuesService.setCBSConnectivityDetails(cbsClientValues);
        } else {
            String errerValue = "Invalid CBS Connectivity Details";
            this.displayErrorAndClose(errerValue);
        }
    }

    private static void addAllowedMessageTypes(String messageType, CBSClient cbsClient) {
        MessageType messageTypeEnum = Arrays.stream(MessageType.values()).filter(type -> type.name().equals(messageType)).findAny().get();
        cbsClient.addMessageTypes(messageTypeEnum);
    }

    private void displayErrorAndClose(String errorMessage) {
        this.log.error(errorMessage);
        this.log.error("Closing application");
        System.exit(-1);
    }
}

