/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.cbs.rest.service;

import com.cspl.fxretailhub.service.ConfigurationValuesService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.fxretailhub.service.MessageProcessingService;
import com.cspl.fxretailhub.shared.CBSClient;
import javax.inject.Inject;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RESTClientService
implements ICommunicationInterface {
    @Value(value="${ccilfx.hub.bis.rest.protocol}")
    private String interfaceProtocol;
    @Value(value="${ccilfx.hub.bis.rest.identifier}")
    private String interfaceIdentifier;
    @Inject
    private ConfigurationValuesService configurationValuesService;
    private Boolean isConnectSuccess = false;
    @Inject
    @Qualifier(value="RESTTemplate")
    private RestTemplate restTemplate;
    private MessageProcessingService messageProcessingService;
    private static final Logger log = LoggerFactory.getLogger(RESTClientService.class);

    public void initialise(MessageProcessingService messageProcessingService) {
        this.messageProcessingService = messageProcessingService;
    }

    public Boolean isConnected() {
        return true;
    }

    public Boolean sendMessage(String message) {
        boolean sendSuccess = false;
        String bIBaseURL = this.getBaseURI() + "/send";
        String responseString = "";
        try {
            HttpHeaders headers = this.getHeaders();
            HttpEntity requestBody = new HttpEntity((Object)message, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(bIBaseURL, (Object)requestBody, String.class, new Object[0]);
            this.validateResponse(response);
            responseString = (String)response.getBody();
            sendSuccess = true;
        }
        catch (Exception exception) {
            log.error(ExceptionUtils.getFullStackTrace((Throwable)exception));
        }
        return sendSuccess;
    }

    public Boolean sendPIMessage(String message) {
        return null;
    }

    public Boolean sendMessage(String message, CBSClient client) {
        boolean sendSuccess = false;
        String bIBaseURL = this.getBaseURI(client) + "/send";
        log.info("Trying to connect: " + bIBaseURL);
        String responseString = "";
        try {
            HttpHeaders headers = this.getHeaders();
            HttpEntity requestBody = new HttpEntity((Object)message, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(bIBaseURL, (Object)requestBody, String.class, new Object[0]);
            this.validateResponse(response);
            responseString = (String)response.getBody();
            this.messageProcessingService.processHTTPCBSResponseMessage(responseString, client.getApiKey());
            sendSuccess = true;
        }
        catch (Exception exception) {
            log.error(ExceptionUtils.getFullStackTrace((Throwable)exception));
        }
        return sendSuccess;
    }

    private String getBaseURI() {
        return this.interfaceProtocol + "://:8027/" + this.interfaceIdentifier;
    }

    private String getBaseURI(CBSClient client) {
        String port = "";
        port = this.interfaceProtocol.equals("https") ? "443" : client.getPort();
        return this.interfaceProtocol + "://" + client.getIpaddress() + ":" + port + "/" + this.interfaceIdentifier;
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        return headers;
    }

    private <R> void validateResponse(ResponseEntity<R> response) {
        try {
            if (response.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusCode());
            }
        }
        catch (Exception exception) {
            log.debug(exception.getMessage());
            throw new IllegalArgumentException(exception.getMessage());
        }
    }
}

