/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.library;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateLibrary {
    private static final String timeStampFormat = "yyyyMMddHHmmss.nnnnnnnnn";
    private static final String expiryTimeStampFormat = "yyyyMMddHHmmss";
    private static final String settlementTimeStampFormat = "yyyyMMdd";
    private static final String timeStampFormat_ddMMyyyy = "ddMMyyyy";
    private static final String timeStampFormat_dd_MMM_yyyy = "dd-MMM-yyyy";
    private static final String timeStampFormat_dd_MMM_yyyy_HH_mm_ss = "dd-MMM-yyyy HH:mm:ss";

    public static LocalDateTime parseAndGetDateFromGivenStringAndFormat(String value, String format) {
        LocalDateTime returnValue = null;
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern(format);
        try {
            returnValue = LocalDateTime.parse(value.trim(), dateFormat);
        }
        catch (Exception ex) {
            returnValue = null;
        }
        return returnValue;
    }

    public static String getDateStringInGivenFormat(String format, LocalDateTime inputDate) {
        String returnValue = null;
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        returnValue = df.format(inputDate);
        return returnValue;
    }

    public static LocalDateTime getLocalDateTimeFromGivenDate(Date inputDate) {
        ZoneId defaultZoneId = ZoneId.systemDefault();
        return inputDate.toInstant().atZone(defaultZoneId).toLocalDateTime();
    }

    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now();
    }

    public static String getStringFromTimestamp(LocalDateTime timestamp) {
        return DateLibrary.getDateStringInGivenFormat((String)"yyyyMMddHHmmss.nnnnnnnnn", (LocalDateTime)timestamp);
    }

    public static String getStringFromExpiryTimestamp(LocalDateTime timestamp) {
        return DateLibrary.getDateStringInGivenFormat((String)"yyyyMMddHHmmss", (LocalDateTime)timestamp);
    }

    public static String getStringFromSettlementTimestamp(LocalDateTime timestamp) {
        return DateLibrary.getDateStringInGivenFormat((String)"yyyyMMdd", (LocalDateTime)timestamp);
    }

    public static LocalDateTime getTimestampFromString(String timeStampString) {
        return DateLibrary.parseAndGetDateFromGivenStringAndFormat((String)timeStampString.trim(), (String)"yyyyMMddHHmmss.nnnnnnnnn");
    }

    public static LocalDateTime getExpiryTimestampFromString(String timeStampString) {
        return DateLibrary.parseAndGetDateFromGivenStringAndFormat((String)timeStampString.trim(), (String)"yyyyMMddHHmmss");
    }

    public static LocalDateTime getSettlementTimestampFromString(String timeStampString) {
        return DateLibrary.parseAndGetDateFromGivenStringAndFormat((String)timeStampString.trim(), (String)"yyyyMMdd");
    }

    public static LocalDate getSettlementDateFromString(String timeStampString) {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd");
        return LocalDate.parse(timeStampString.trim(), dateFormat);
    }

    public static String convertDateTimeFromOneStringToAnotherString(String value, String fromFormat, String toFormat) {
        LocalDateTime dateWithTime = DateLibrary.parseAndGetDateFromGivenStringAndFormat((String)value, (String)fromFormat);
        return DateLibrary.convertDateTimeToString((LocalDateTime)dateWithTime, (String)toFormat);
    }

    public static String convertDateTimeToString(LocalDateTime value, String format) {
        return DateTimeFormatter.ofPattern(format).format(value);
    }
}

