/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.pi.services.thread;

import com.cspl.fxretailhub.pi.services.PIMessageSendingService;
import com.cspl.fxretailhub.pi.services.PIMessagingService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.pi.services.dto.PIQueueDTO;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PIMessageSendingThread
extends Thread {
    private Logger log = LoggerFactory.getLogger(PIMessageSendingThread.class);
    private PIMessageSendingService messageSendingService;
    private PIMessagingService messagingService;
    private ICommunicationInterface communicationInterface;

    public PIMessageSendingThread(PIMessagingService messagingService, PIMessageSendingService messageSendingService, ICommunicationInterface communicationInterface) {
        this.messagingService = messagingService;
        this.messageSendingService = messageSendingService;
        this.communicationInterface = communicationInterface;
    }

    @Override
    public void run() {
        this.log.info("PI client socket write thread started");
        Boolean sendSuccess = false;
        while (true) {
            try {
                while (true) {
                    PIQueueDTO message;
                    if ((message = this.messagingService.checkAndGetMessageFromPIQueue()) != null) {
                        sendSuccess = false;
                        this.log.info("PI Message fetched from queue");
                        while (!sendSuccess.booleanValue()) {
                            if (this.communicationInterface.isConnected().booleanValue()) {
                                sendSuccess = this.messageSendingService.checkAckAndSendMessage(this.messagingService, message);
                                if (!sendSuccess.booleanValue()) {
                                    Thread.sleep(500L);
                                    this.log.info("Resending PI message");
                                    continue;
                                }
                                this.messagingService.updateSentStatus(message);
                                continue;
                            }
                            Thread.sleep(500L);
                        }
                        Thread.sleep(20L);
                        continue;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                this.log.error("Exception while execution - " + ExceptionUtils.getFullStackTrace((Throwable)ex));
                continue;
            }
            break;
        }
    }
}

