/*
 * Decompiled with CFR 0.152.
 */
package com.cspl.fxretailhub.service;

import com.cspl.api.enumeration.ChannelTypeLookup;
import com.cspl.fxretailhub.cbs.rest.service.RESTClientService;
import com.cspl.fxretailhub.cbs.service.CBSMessagingService;
import com.cspl.fxretailhub.enumeration.PIProtocols;
import com.cspl.fxretailhub.pi.rest.service.PIRESTClientService;
import com.cspl.fxretailhub.pi.services.PIMessagingService;
import com.cspl.fxretailhub.service.ConfigurationValuesService;
import com.cspl.fxretailhub.service.ICommunicationInterface;
import com.cspl.fxretailhub.service.MessageProcessingService;
import com.cspl.pi.shared.PISharedValues;
import javax.inject.Inject;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StartupService {
    @Inject
    private ConfigurationValuesService configurationValuesService;
    @Inject
    private MessageProcessingService messageProcessingService;
    @Inject
    private RESTClientService restClientService;
    @Inject
    private CBSMessagingService cbsMessagingService;
    @Inject
    private PIRESTClientService piRestClientService;
    @Inject
    private PIMessagingService piMessagingService;
    private Logger log = LoggerFactory.getLogger(StartupService.class);

    public void validateHUBConfigurations() throws Exception {
        if (!EnumUtils.isValidEnum(PIProtocols.class, (String)this.configurationValuesService.getHubProtocol())) {
            this.displayErrorAndClose("Invalid HUB protocol");
        }
    }

    private void displayErrorAndClose(String errorMessage) {
        this.log.error(errorMessage);
        this.log.error("Closing application");
        System.exit(-1);
    }

    public void initalise() throws Exception {
        try {
            if (this.configurationValuesService.getHubProtocol().equals(PIProtocols.NONE.toString())) {
                this.log.info("Communication to PI and BIS is disabled");
            } else {
                if (!this.configurationValuesService.getHubProtocol().equals(PIProtocols.TCPIP.toString()) && this.configurationValuesService.getHubProtocol().equals(PIProtocols.HTTP.toString())) {
                    this.restClientService.initialise(this.messageProcessingService);
                    this.cbsMessagingService.initialise((ICommunicationInterface)this.restClientService);
                    PISharedValues.channel = ChannelTypeLookup.REST_API.getCode();
                    this.piRestClientService.initialise(this.messageProcessingService);
                    this.piMessagingService.initialise((ICommunicationInterface)this.piRestClientService);
                    this.piMessagingService.fetchAndProcessUnSentMessages();
                }
                this.messageProcessingService.initialise();
                this.configurationValuesService.setIsEnableRESTAPI(Boolean.valueOf(true));
                this.log.info("Initialise HUB as " + this.configurationValuesService.getHubProtocol() + " server complete");
                if (this.configurationValuesService.getEncryptionRequired().booleanValue()) {
                    this.log.info("Initialise HUB with encryption");
                } else {
                    this.log.info("Initialise HUB without encryption");
                }
            }
        }
        catch (Exception ex) {
            this.log.error("Error in initalise : " + ex.getMessage());
            throw ex;
        }
    }
}

